#version 150
#extension GL_EXT_gpu_shader4 : enable
///////////////////////////////////////////////////////////////////////////////////////////////////
// iStripper wrapper for Shadertoy conversions by @Calgon  //
///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Notes
//
// Idea was to create a standard wrapper around Shadertoy code that could be applied to any shader
// sourced from Shadertoy.
// Version number is 150 as standard but where later functions are found this is changed to 330

// Wrapper Follows....
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Declare the missing thingamies that aren't available on VGHD
uniform vec3  iChannelResolution[4];	// BUT WE NEED TO FILL THEM !
uniform float iChannelTime[4];

//#define iResolution u_WindowSize
#define iResolution vec3(u_WindowSize, 0)	// Because Shadertoy iResolution is a vec3
#define iFrame 0


//Slow the time functions down a little as standard
//#define iTime u_Elapsed * .5
float iTime;

#define iGlobalTime u_Elapsed * .5

// Seems the word texture is important and should not be replaced.  Therefore we must replace
// Shadertoy texture0..3 with texture 0..3 further down
uniform sampler2D texture0; //Random Surfaces
uniform sampler2D texture1; //Water
uniform sampler2D texture2; //Random Greys
uniform sampler2D texture3; //More surfaces

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture(sampler,fract(P),Bias);}

#define texture texture2D_Fract	// So whenever Shadertoy says "texture" we run it through this Macro
// Can we do the same for Cubemaps 

#define iChannel0 texture0
#define iChannel1 texture1
#define iChannel2 texture2
#define iChannel3 texture3

// Mouse Simulation from @TheEmu	
#define iMouse vec4(0.)
// Alternative Macro if iMouse is better moving
//#define iMouse AUTO_MOUSE  //vec4(0.0,0.0,0.0,0.0)
// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.
#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
//#define MOUSE_POS vec2((0.25+sin(iTime*MOUSE_SPEED*2))*u_WindowSize/2.0)
//#define MOUSE_POS vec2((sin(iTime*1)*.5*u_WindowSize.x/2.0),1.0*u_WindowSize.y/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
#define MOUSE_PRESS vec2(1.0,1.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )



vec4 iDate;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Uniforms to control timing of each shader
//uniform float cycle_time;
uniform float bgnum;
uniform float maxbgnum;
//uniform float alpha_off;
//uniform float alpha_on;
//uniform float alpha_always_on;
uniform float scene_duration;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Extract a pixel from texture1 to get the random number
float randNum = texture(texture2, vec2(0.0, 0.0)).r;
float seed_start = 3*randNum-1.5;



///////////////////////////////////////////////////////////////////////////////////////////////////
// Shadertoy Code follows
///////////////////////////////////////////////////////////////////////////////////////////////////

// Sourced from https://www.shadertoy.com/view/NdlGzs

// This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 3.0
// Unported License. To view a copy of this license, visit http://creativecommons.org/licenses/by-nc-sa/3.0/ 
// or send a letter to Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.
// =========================================================================================================
//
// You can make it your window terminal background following link here :
// https://github.com/seb776/WindowsTerminalShaders
//
#define sat(a) clamp(a, 0., 1.)
#define PI 3.141592653

mat2 r2d(float a) { float c= cos(a), s = sin(a); return mat2(c,-s,s,c);}
float lenny(vec2 v) { return abs(v.x)+abs(v.y); }

float _cir(vec2 uv, float r)
{
    return length(uv)-r;
}

float _sqr(vec2 p, vec2 s)
{
    vec2 l = abs(p)-s;
    return max(l.x, l.y);
}

float _nimal(vec2 uv)
{

    uv.x+=sin(uv.y*25.+iTime*2.)*0.01*sat(uv.y*5.);
    vec2 tuv = (uv-vec2(0.11+0.01*sin(uv.y*30.-iTime*4.),-.05)) * r2d(PI/4.);

    tuv.x = abs(tuv.x);
    tuv = (tuv-vec2(-.07,0.));
    float tail = _cir(tuv, .1);
    uv -= vec2(0.05,-.03);
    float body = 10.;
    
    float anhears = 0.1;
    vec2 offhears = vec2(0.01,0.);
    body = min(body, _sqr((uv+offhears)*r2d(anhears), vec2(.025,.07)));
    body = min(body, _sqr((uv-offhears)*r2d(-anhears), vec2(.025,.07)));
    body = max(body, -_sqr((uv-vec2(0.,.08))*r2d(PI/4.), vec2(.03)));
    uv.x = abs(uv.x);
    body = min(body, _cir(uv*vec2(1.,.8)-vec2(.02,-0.04),.03));
    body = min(body, _cir(uv*vec2(1.,.8)-vec2(.048,-0.058),.005));
    body = min(body, tail);
    return body;
}

float _star(vec2 p, vec2 s)
{
    float a = _sqr(p, s.xy);
    float b = _sqr(p, s.yx);
    return min(a, b);
}

float _stars(vec2 uv, vec2 szu)
{
    uv *= r2d(PI/4.);
    vec2 ouv = uv;
    float th = 0.002;
    vec2 rep = vec2(0.1);

    vec2 idx = floor((uv+rep*.5)/rep);
    
    uv = mod(uv+rep*.5, rep)-rep*.5;
    float sz = sat(sin(idx.x*5.+idx.y+iTime))*sat(length(ouv*2.)-.5);
    return _star(uv, vec2(20.*th, th)*.5*sz*szu);
}

vec3 rdr(vec2 uv)
{
    float shp = 400.;
    vec3 background = vec3(0.431,0.114,0.647)*.2;
    
    background = mix(background, vec3(1.000,0.761,0.239), 1.-sat(_stars(uv, vec2(1.))*shp));
    
    vec3 sunCol = vec3(1.000,0.761,0.239);
    vec3 foregroundBack = vec3(0.345,0.125,0.494);
    
    vec3 foreground;
    
    float sun = _cir(uv, .02);
    float sstp = 0.05;
    sun = floor(sun/sstp)*sstp;
    foreground = mix(foregroundBack, sunCol, 1.-sat(sun*4.));
    
    float mount = uv.y-asin(sin(uv.x*25.))*.01+.1;
    foreground = mix(foreground, foreground*.3, 1.-sat(mount*shp*.5));
    
    float mount2 = uv.y-(sin(uv.x*25.+2.))*.05+.1;
    foreground = mix(foreground, foreground*.5, 1.-sat(mount2*shp*.1));

    
    float hill = _cir(uv-vec2(0.,-.9), .8);
    foreground = mix(foreground, vec3(0.), 1.-sat(hill*shp));

    float nanimal =_nimal(uv);
    foreground = mix(foreground, vec3(0.), 1.-sat(nanimal*shp));
    
    
    float mask = _cir(uv, .25);
    
    vec3 col = mix(background, foreground, 1.-sat(mask*shp));
    
    col += (1.-sat(length(uv*3.)))*sunCol*.7;
    float flicker = .1;
    col += pow(1.-sat(lenny(uv*vec2(1.,2.))),5.)*sunCol*.7
        *mix(.95,1., sat(sin(iTime*25.)*2.+sin(iTime*40.)));
    
    col = mix(col, vec3(1.000,0.761,0.239), sat(length(uv)-.1)*(1.-sat(_stars(uv*.8, vec2(5.))*shp*.3))*.7);
    return col;
}



void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (fragCoord-vec2(.5)*iResolution.xy)/iResolution.xx;

    vec3 col = rdr(uv);
    
    col *= mix(-1.,1.,1.-sat(lenny(uv*2.)-.5));
    col = sat(col);
    
    fragColor = vec4(col,1.0);
}


///////////////////////////////////////////////////////////////////////
// Shadertoy footer wrapper
///////////////////////////////////////////////////////////////////////

void main ( void )
{
	float alpha_on;
	float alpha_off;


	if (bgnum > 0){
		alpha_on  = scene_duration * (bgnum - 1.);
		alpha_off = scene_duration * (bgnum + 0.);
	}
	if (bgnum == 0){
		alpha_on  = scene_duration * (maxbgnum) - 1;
		alpha_off = scene_duration * (maxbgnum) + 1;
	}

	
	
	

	iTime = u_Elapsed * .5;


	if (iTime > 6000.){
		iTime = 6000. * fract(iTime / 6000.);
	}
	float cycle_time = maxbgnum * scene_duration;
	float cycles = (u_Elapsed)/cycle_time;
	float full_cycles = trunc(cycles);
    float part_cycles = u_Elapsed - (full_cycles * cycle_time);
	
	vec4 blank = vec4(0.);
	
	// Run the full program only at the right time..
	if ((part_cycles > alpha_on-1.)&&(part_cycles <= alpha_off+1.)){
		mainImage ( gl_FragColor, gl_FragCoord.xy );
		gl_FragColor.a = 1.0;
	}
	// Otherwise... just blank => massive performance boost
	else{
		gl_FragColor = blank;		
    }
	// Still need to fade it
	gl_FragColor.a = 0.0;
   if (part_cycles > alpha_on-1.){
	if (part_cycles <= alpha_off){
		gl_FragColor.a = 1.;
		if ((alpha_off - part_cycles)<1.){
			gl_FragColor.a = alpha_off - part_cycles;
		}
	}
   }
}


